<?php

namespace FirstpointCh\Cream\Filters;

use ReflectionClass;
use Illuminate\Support\Str;

abstract class Filter
{
    public $handler;

    /**
     * if true, this filter will be applied even with null value
     *
     * @var boolean
     */
    public bool $allowNull = false;

    public bool $displayInline = false;

    public static function make(...$args)
    {
        return new static(...$args);
    }

    public function view(): string
    {
        $class = new ReflectionClass($this);

        return 'cream::filters.' . Str::slug(Str::snake($class->getShortName()));
    }

    public function handle(callable $handler): self
    {
        $this->handler = $handler;

        return $this;
    }

    public function getValue($value = null)
    {
        return $value;
    }

    public function inline(bool $inline = true): self
    {
        $this->displayInline = $inline;

        return $this;
    }
}
