<?php

namespace FirstpointCh\Cream;

use ReflectionClass;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Route;

class Cream
{
    public Navigation $navigation;

    public function __construct()
    {
        $this->navigation = new Navigation;
    }

    public function navigation(callable $callback): self
    {
        $callback($this->navigation);

        return $this;
    }

    public static function getResourceRouteName($resource, $action): ?string
    {
        $name = (new ReflectionClass($resource))->getShortName();

        $singular = Str::camel($name);
        $plural = Str::kebab(
            Str::plural($name)
        );

        $route = "app.{$plural}.{$action}";

        if (!Route::has($route)) {
            return null;
        }

        $parameters = [];

        if (in_array($action, ['show', 'edit', 'delete'])) {
            $parameters[$singular] = $resource->id;
        }

        return route($route, $parameters);
    }
}
